#!/bin/sh

project=$1
sn=$2
mode=$3
result=$4
desc=$5
log=$6

#ftp_server="183.57.46.131"
ftp_server="ftp.productiontest.com"
ftp_user="productiontest"
ftp_passwd="productiontest"

loop_count=2
upload_result=0

if [ $# != 6 ];then
	echo "bad input param."
	exit 1
fi

if [ ${#sn} -lt 4 ];then
	echo "input bad sn,sn=[${sn}]."
	exit 2
fi

# get factory synbol from sn
factory=${sn:0:4}
if [ ${#factory} -lt 0 ];then
	echo "bad factory name,factory=[${factory}], sn=[${sn}]."
	exit 3
fi

# get upload timestamp and generate the logfile name by input params.
upload_date=`date "+%Y%m%d%H%M%S"`
logfile=${factory}_${project}_${upload_date}_${sn}_${mode}_${result}_${desc}.tar.gz

if [ -d "${log}" ];then
	tar -czhf /tmp/${logfile} -C ${log}/ .
fi

if [ -f "${log}" ];then
	filename=${log##*/}
	logdir=${log%/*}
	if [ ! -d ${logdir} ];then
		echo "bad logname format, log::[${log}]"
		exit 4
	fi
	tar -czhf /tmp/${logfile} -C ${logdir}/ ${filename}
fi
sync

if [ ! -f "/tmp/${logfile}" ];then
	echo "create logfile::${logfile} failed."
	exit 5
fi

# upload logfile to ftp server
date_dir=`date "+%Y%m%d"`
for count in `seq $loop_count`
do
	curl --connect-timeout 5 -u "${ftp_user}:${ftp_passwd}" ftp://${ftp_server}/ -X "MKD ${date_dir}"

	#  2.upload logfile to the specified dir.
	curl --connect-timeout 5 -u "${ftp_user}:${ftp_passwd}" ftp://${ftp_server}/${date_dir}/ -T "/tmp/${logfile}"

	upload_result=$?
	if [ ${upload_result} -ne 0 ]; then
		echo "upload /tmp/${logfile} to ftp server ${ftp_server} failed ${upload_result}."
	else
		echo "upload /tmp/${logfile} to ftp server ${ftp_server} success."
		break
	fi
done

rm /tmp/${logfile}
sync

if [ ${upload_result} -ne 0 ]; then
    exit 6
else
    exit 0
fi

